package nestedstate.tools;

import com.ibm.xml.parser.*;
import org.w3c.dom.*;
import java.io.*;
import nestedstate.*;

public class FSMGenerator
{
        public static Element parse(String filename)
        {
                if (filename != null) 
                {
                        InputStream is;
                        try 
                        {
                                is = new FileInputStream(filename);
                        } 
                        catch (FileNotFoundException notFound) 
                        {
                                System.err.println(notFound);
                                return null;
                        }
                        Document doc = new Parser(filename).readStream(is);
                        Element root = (Element)doc.getDocumentElement();                        
                        return root;
                 }
                return null;
        }
        
        public static void declareStates(Element root, FSM fsm)        
        {              
                NodeList statesList = root.getElementsByTagName("states");
                if( statesList.getLength() > 0 )
                {
                        Element states = (Element)statesList.item(0);
                        NodeList nl = states.getChildNodes();
                        for(int i = 0 ;  i < nl.getLength(); i++)
                        {
                                try 
                                {
                                        Element child = (Element)(nl.item(i));
                                        createState(child, FSM.ROOT, fsm);
                                }
                                catch(Exception e)
                                {
                                }
                        }
                
                        String defaultState = states.getAttribute("default");
                        if(defaultState != null)
                        {
                                
                                fsm.getRoot().setDefaultState(
                                        fsm.getStateWithName(defaultState));
                        }
                        else
                        {
                                throw new Error("No default state for root");
                        }
                }
        }
        

        public static void createState(Element state, 
                                       String parent, 
                                       FSM fsm)
        {
                if(state.getChildNodes().getLength() == 0)
                {
                        createLeafState(state, parent, fsm);
                }
                else
                {
                        createNodeState(state, parent, fsm);
                }
        }

        public static void createNodeState(Element state, 
                                           String parent, 
                                           FSM fsm)
        {
                try {
                        String statename = state.getAttribute("name");
                        fsm.addNodeState(statename, parent);
                               
                        NodeList nl = state.getChildNodes();
                        for(int i = 0 ;  i < nl.getLength(); i++)
                        {
                                try
                                {
                                        Element child = (Element)nl.item(i);
                                        createState(child, statename,  fsm);
                                }
                                catch(Exception e)
                                {
                                }
                        }
                } 
                catch(Exception e) 
                { 
                        e.printStackTrace(); 
                }
        }

        public static void createLeafState(Element state, 
                                           String parent, 
                                           FSM fsm)
        {
                try {
                        String name = state.getAttribute("name");                        
                        String initaction = state.getAttribute("initaction");
                        FSMAction init = 
                                (FSMAction)Serializer.deserialize(initaction);

                        String exitaction = state.getAttribute("exitaction");
                        FSMAction exit = 
                                (FSMAction)Serializer.deserialize(exitaction);
                        if(init != null && exit != null)
                        {
                                fsm.addLeafState(init,name,exit,parent);
                        }
                        else if(init != null)
                        {
                                fsm.addLeafState(init,name,parent);
                        }
                        else if(exit != null)
                        {
                                fsm.addLeafState(name,exit,parent);
                        }
                        else
                        {
                                fsm.addLeafState(name,parent);
                        }
                } 
                catch(Exception e) 
                { 
                        e.printStackTrace(); 
                }
        }

        public static void declareEvents(Element root, FSM fsm)        
        {
                NodeList nl = root.getElementsByTagName("event");
                for(int i = 0 ;  i < nl.getLength(); i++)
                {
                        createEvent((Element)nl.item(i), fsm);
                }
        }

        public static void createEvent(Element event, FSM fsm)
        {
                try {
                String eventname = event.getAttribute("name");
                fsm.addEvent(eventname);
                } catch(Exception e) { e.printStackTrace(); }
        }

        public static void declareTransitions(Element root, FSM fsm)        
        {
                NodeList nl = root.getElementsByTagName("transition");
                for(int i = 0 ;  i < nl.getLength(); i++)
                {
                        createTransition((Element)nl.item(i), fsm);
                }
        }
        
        public static void createTransition(Element transition, FSM fsm)
        {
                try {
                String sourcestate = transition.getAttribute("sourcestate");
                String targetstate = transition.getAttribute("targetstate");
                String event = transition.getAttribute("event");
                String action = transition.getAttribute("action");
                FSMAction fsmaction = 
                        (FSMAction)Serializer.deserialize(action);
                if(action == null)
                        fsm.addTransition(sourcestate, 
                                          event, 
                                          targetstate, 
                                          LeafState.skip);
                else
                        fsm.addTransition(sourcestate, 
                                          event, 
                                          targetstate, 
                                          fsmaction);
                } catch(Exception e) { e.printStackTrace(); }
        }
        
        
        public static FSM generateFSM(String filename)
        {
                FSM fsm = new FSM();
                Element root = parse(filename);
                declareStates(root, fsm);
                declareEvents(root, fsm);
                declareTransitions(root, fsm);
                String initaction = root.getAttribute("initaction");
                if(initaction != null)
                {
                        try{
                                fsm.setInitAction(
                                    (FSMAction)Serializer.deserialize(initaction));
                        } catch(Exception e) {}
                }
                return fsm;
        }                
}